import React from 'react'
import Layout from "~/components/layout";
import {Box} from './styled';
import ImagePreview from './components/picture-preview';
import { Button , Image as AImage , Divider } from 'antd';
import Image from 'next/image';
import errImg from "~/assets/errImg";

export default function EquipmentLeasingDetail() {
  return (
    <Layout>
      <Box>
        <div className='item'>
          <ImagePreview />
          <div className='item-right'>
            <div className='title'>入云龙1550</div>
            <div className='function'>
              <div className='function-item'>官方质检</div>
              <div className='function-item'>1天起租</div>
              <div className='function-item'>极速发货</div>
              <div className='function-item'>渠道商免押</div>
            </div>
            <div className='menoy'>
              <span className='menoy-left'>¥200</span>
              <span className='menoy-right'>/天起</span>
            </div>
            <div className='classification'></div>
            <div className='botton-btn'>
                  <Button className='btn-left' size='small' type="primary">成为渠道商</Button>
                  <Button className='btn-right' size='small' type="primary">立即租赁</Button>
            </div>
          </div>
        </div>
        <div className='flow-path'>
              <Image className='image' src={require("./assets/flow-path.png")} alt="" />
        </div>
        <div className='prompt'>
          更多租金规则请前往【云享飞】微信小程序查
        </div>
        <Divider className='divider'>商品详情</Divider>
        <div style={{ textAlign: "center" }}>
          <AImage fallback={errImg} width={1080}></AImage>
        </div>
      </Box>
    </Layout>
  )
}
